unit DFilterDialog01;

// ========================================================================
//
//   
//
// ========================================================================

interface

uses
  //  
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Grids, ExtCtrls, Buttons, ComCtrls, Menus,
  //        
  EngineImgService01, MainData, SGridEdit01,
  //    
  DFilterData01, DFilterService01, DFilterPopular,
  //   MICROBASE
  MbMain, ToolWin, ImgList;

type
  TFormDFilter = class(TForm)
    PanelDFilter1: TPanel;
    Label9: TLabel;
    MainMenu1: TMainMenu;
    MMFiles: TMenuItem;
    MMFilters: TMenuItem;
    MMPopFilterH: TMenuItem;
    MMOperation: TMenuItem;
    MMPopFilterL: TMenuItem;
    N11: TMenuItem;
    N12: TMenuItem;
    MMHelp: TMenuItem;
    MMExit: TMenuItem;
    MMPopFilterH1: TMenuItem;
    MMPopFilterH2: TMenuItem;
    MMPopFilterH3: TMenuItem;
    MMPopFilterL1: TMenuItem;
    MMPopFilterL2: TMenuItem;
    MMPopFilterL3: TMenuItem;
    PanelFragImages: TPanel;
    ScrollBox1: TScrollBox;
    ImgTestSource: TImage;
    ScrollBox2: TScrollBox;
    ImgTestTarget: TImage;
    Splitter1: TSplitter;
    ProgressBar1: TProgressBar;
    ToolBar1: TToolBar;
    TB1RunDest: TToolButton;
    TB1RunFrag: TToolButton;
    PanelDFilter2: TPanel;
    SGridFilter: TStringGrid;
    ToolBar2: TToolBar;
    TB2GoToDB: TToolButton;
    TB2FilterPlus: TToolButton;
    TB2FSep1: TToolButton;
    Label11: TLabel;
    EdFScale: TEdit;
    TB1Sep1: TToolButton;
    TB1Sep2: TToolButton;
    ImageList1: TImageList;
    TB2Sep2: TToolButton;
    TB2FilterMinus: TToolButton;
    MMGoToDB: TMenuItem;
    TrackBarLight: TTrackBar;
    TrackBarContrast: TTrackBar;
    Image1: TImage;
    Image2: TImage;
    Bevel1: TBevel;
    Label1: TLabel;
    // -----------------------------------
    procedure FormCreate(Sender: TObject);
    procedure MMExitClick(Sender: TObject);
    // -----------------------------------
    //   OnGetEditText -    
    procedure SGridFilterSetEditText(Sender: TObject; ACol, ARow: Integer;
      const Value: String);
    //    
    procedure EdFScaleChange(Sender: TObject);
    // -----------------------------------
    procedure TB1RunFragClick(Sender: TObject);
    procedure TB1RunDestClick(Sender: TObject);
    // -----------------------------------
    procedure TB2GoToDBClick(Sender: TObject);
    procedure MMGoToDBClick(Sender: TObject);
    // -----------------------------------
    procedure TB2FilterPlusClick(Sender: TObject);
    procedure TB2FilterMinusClick(Sender: TObject);
    procedure MMPopFilterH1Click(Sender: TObject);
    procedure MMPopFilterH2Click(Sender: TObject);
    procedure MMPopFilterH3Click(Sender: TObject);
    procedure MMPopFilterL1Click(Sender: TObject);
    procedure MMPopFilterL2Click(Sender: TObject);
    procedure MMPopFilterL3Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    // -----------------------------------
  private
    //    
    procedure SetFiltrPopular(RqArrFilter : TArrFPoular);
    //          
    procedure ShowFiltr();
  public
    { Public declarations }
  end;

var FormDFilter : TFormDFilter;

implementation

{$R *.dfm}

// ========================================================================
//    
// ========================================================================
// 01.02.2013
//  
procedure TFormDFilter.FormCreate(Sender: TObject);
begin
   //   StringGrid Editor (unit SGridEdit01)
   InitSGridEd(SGridFilter, DFilterMaxLen);
   //   SGridFilter   OnSetEditText
   SGridFilter.OnSetEditText := SGridFilterSetEditText;
end;
//-------------------------------------------------------------------------
//    
procedure TFormDFilter.MMExitClick(Sender: TObject);
begin
   Close; 
end;
//-------------------------------------------------------------------------
// 01.02.2013
//     (     Show)
procedure TFormDFilter.FormShow(Sender: TObject);
begin
   //  
   // ShowMessage ('   ');
end;

// ========================================================================
//    
// ========================================================================
// 01.02.2013
//   OnGetEditText -    
procedure TFormDFilter.SGridFilterSetEditText(Sender: TObject; ACol,
  ARow: LongInt; const Value: String);
var BufInt : integer;
begin
  BufInt := DFiltrArray[ARow, ACol];
  //    StringGrid   
  //  DFiltrArray       
  if EditIntegerCell(Sender, ACol, ARow, Value, BufInt)
  then DFiltrArray[ARow, ACol] := BufInt
  else begin
     with (Sender as TStringGrid)
     do begin
        if BufInt = 0
        then Cells[ACol, ARow] := ''
        else Cells[ACol, ARow] := IntToStr(BufInt);
     end;
  end;
  //    
  CalculateScale(EdFScale);
end;
//-------------------------------------------------------------------------
// 01.02.2013
//    
procedure TFormDFilter.EdFScaleChange(Sender: TObject);
begin
  TextToInt (EdFScale.Text, DFiltrScale);
end;

// ========================================================================
//     . (unit DigitFilter01)
// ========================================================================
// 30.01.2012
//     
procedure TFormDFilter.TB1RunFragClick(Sender: TObject);
begin
 //  
 if VerifyFilterScale()
 then begin
    //  BGR-   Color-
    TabBRGtoTabColor (Addr(ArrFragSrcBGR),Addr(ImgTabColorSrc));
    //    Color-
    DFilterAplly (DFiltrArray,
                  DFiltrScale,            // DFiltrScale
                  Addr(ImgTabColorSrc),
                  Addr(ImgTabColorTrg));
    //   Src- 
    SetLength(ImgTabColorSrc,0);
    //  Color-   BGR-
    TabColorToTabBRG (Addr(ImgTabColorTrg), Addr(ArrFragTrgBGR));
    //   Target- 
    SetLength(ImgTabColorTrg,0);
    //     Image 
    ImgTabToImage(Addr(ArrFragTrgBGR),
                       ImgTestTarget,
                       ProgressBar1);
  end
  else MessageDlg('  ',
                  mtWarning,
                  [mbOk], 0);
end;
//-------------------------------------------------------------------------
// 30.01.2012
//     .    
procedure TFormDFilter.TB1RunDestClick(Sender: TObject);
begin
 //  
 if VerifyFilterScale()
 then begin
     //    
     Screen.Cursor := crHourGlass;
     try
       //  BGR-    Color-
       TabBRGtoTabColor (Addr(SrcImgTabBGR),Addr(ImgTabColorSrc));
       //    Color-
       DFilterAplly (DFiltrArray,
                     DFiltrScale,           // DFiltrScale
                     Addr(ImgTabColorSrc),
                     Addr(ImgTabColorTrg));
       //   Src- 
       SetLength(ImgTabColorSrc,0);
       //  Color-   BGR-
       TabColorToTabBRG (Addr(ImgTabColorTrg), Addr(TrgImgTabBGR));
       //   Target- 
       SetLength(ImgTabColorTrg,0);
       //     Image  
       ImgTabToImage(Addr(TrgImgTabBGR),  // BGR-  
                     pImageTarget,   // Image  
                     ProgressBar1);
       //    
       pPageControlMain.TabIndex := 1;
    finally
       //     
       Screen.Cursor := crDefault	;
       //    
       Close;
    end;
 end
 else MessageDlg('  ',
                  mtWarning,
                  [mbOk], 0);
end;

// ========================================================================
//   . (unit DFilterPopular)
// ========================================================================
// 01.02.2012
//    
procedure TFormDFilter.SetFiltrPopular(RqArrFilter : TArrFPoular);
var ARow, ACol : integer;
begin
   with SGridFilter do
   begin
      for ARow := Low(RqArrFilter) to High(RqArrFilter) do
      begin
          for ACol := Low(RqArrFilter[0]) to High(RqArrFilter[0]) do
          begin
            DFiltrArray[ARow, ACol] := RqArrFilter[ARow, ACol];
            if RqArrFilter[ARow, ACol] <> 0
            then Cells[ACol, ARow] := IntToStr(RqArrFilter[ARow, ACol])
            else Cells[ACol, ARow] := '';
          end;
      end;
   end;
   CalculateScale(EdFScale);
end;
//-------------------------------------------------------------------------
//       (ToolBar2)
procedure TFormDFilter.TB2FilterPlusClick(Sender: TObject);
begin SetFiltrPopular(FilterH1) end;

//       (ToolBar2)
procedure TFormDFilter.TB2FilterMinusClick(Sender: TObject);
begin SetFiltrPopular(FilterL1) end;
//-------------------------------------------------------------------------
//     ()
procedure TFormDFilter.MMPopFilterH1Click(Sender: TObject);
begin SetFiltrPopular(FilterH1) end;

//     ()
procedure TFormDFilter.MMPopFilterH2Click(Sender: TObject);
begin SetFiltrPopular(FilterH2) end;

//     ()
procedure TFormDFilter.MMPopFilterH3Click(Sender: TObject);
begin SetFiltrPopular(FilterH3) end;
//-------------------------------------------------------------------------
//     ()
procedure TFormDFilter.MMPopFilterL1Click(Sender: TObject);
begin SetFiltrPopular(FilterL1) end;

//     ()
procedure TFormDFilter.MMPopFilterL2Click(Sender: TObject);
begin SetFiltrPopular(FilterL2) end;

//     ()
procedure TFormDFilter.MMPopFilterL3Click(Sender: TObject);
begin SetFiltrPopular(FilterL3) end;

// ========================================================================
//    . (unit MbMain)
// ========================================================================
// 03.02.2012
//          
procedure TFormDFilter.ShowFiltr();
var ARow, ACol : integer;
begin
   with SGridFilter do
   begin
      for ARow := 0 to High(DFiltrArray) do
      begin
          for ACol := 0 to High(DFiltrArray[0]) do
          begin
            if DFiltrArray[ARow, ACol] <> 0
            then Cells[ACol, ARow] := IntToStr(DFiltrArray[ARow, ACol])
            else Cells[ACol, ARow] := '';
          end;
      end;
   end;
   EdFScale.Text := IntToStr(DFiltrScale);
   //  DFiltrType  DFilterName   
end;
//-------------------------------------------------------------------------
// 03.02.2012
//   MicroBase
procedure TFormDFilter.TB2GoToDBClick(Sender: TObject);
begin
  MbSetFilter := False;
  MbMain.FormMicroBase.ShowModal;
  //   MicroBase
  if MbSetFilter
  then begin
    // MicroBase    MbSetFilter = True
    //     s   
    ShowFiltr();
    MbSetFilter := False;
  end;
end;
//   MicroBase
procedure TFormDFilter.MMGoToDBClick(Sender: TObject);
begin
  MbSetFilter := False;
  MbMain.FormMicroBase.ShowModal;
  //   MicroBase
  if MbSetFilter
  then begin
    // MicroBase    MbSetFilter = True
    //     s   
    ShowFiltr();
    MbSetFilter := False;
  end;
end;

// ========================================================================
//      
// (  )
// ========================================================================
// 06.02.2013
procedure TFormDFilter.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
//  Src- 
   MimimizeBitMap (ImgTestSource.Picture.Bitmap);   //  BitMap
   SetLength(ArrFragSrcBGR,0);
   SetLength(ImgTabColorSrc,0);
//  Target- 
   MimimizeBitMap (ImgTestTarget.Picture.Bitmap);   //  BitMap
   SetLength(ArrFragTrgBGR, 0);
   SetLength(ImgTabColorTrg,0);
end;

// ========================================================================
//               END OF IMPLEMENTATION
// ========================================================================

end.
